#include <Complex.h>
#include <LEDA/dictionary.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>

typedef dictionary<int,Complex> superpos;

double inv_sqrt2 = 1/sqrt(2);

void ligne(int N, superpos &sup) {
  int i,j;

  for (i=N-1; i>=0; i--) {
    dic_item it;
    double proba=0;
    forall_items(it,sup) {
      if (sup.key(it)&(1<<i))           // i-eme cellule est 1
	proba += norm(sup.inf(it));
    }
    int gris = 255-int(proba*255);
    for(j=0; j<3; j++) {
      cout << gris << " ";
    }
  }
  cout <<  endl;
}
 
void Ligne(int N, superpos &sup) {
  dic_item it;

  cout << endl;
  forall_items(it,sup) {
    for (int i=N-1; i>=0; i--) 
      cout << ((sup.key(it)&(1<<i))?"1":"0");
    cout << "\t" << sup.inf(it) << endl;
  }
}
      
  

ajout (int N, superpos &neu, Complex ampl, int conf, 
       int pos=0, int voisin=0) {
  if (pos==N) {
    dic_item it = neu.lookup(conf);
    if (it) 
      neu[it] += ampl;
    else 
      neu.insert(conf, ampl);
  }
  else 
    if (voisin) {                      // faire qflip
      voisin = (conf&(1<<pos));
      if (voisin) {
	ajout(N, neu, -ampl*inv_sqrt2, conf, pos+1, voisin); // 1->1
	ajout(N, neu,  ampl*inv_sqrt2, conf^(1<<pos), pos+1, voisin); // 1->0
      }
      else {
	ajout(N, neu,  ampl*inv_sqrt2, conf, pos+1, voisin); // 0->0
	ajout(N, neu,  ampl*inv_sqrt2, conf^(1<<pos), pos+1, voisin); // 0->1
      }
    }
    else                               // ne rien changer
      ajout(N, neu, ampl, conf, pos+1, conf&(1<<pos));
}

void evol(int N, superpos &alt, superpos &neu) {
  dic_item it;
  
  forall_items(it,alt) {
    ajout(N, neu, alt.inf(it), alt.key(it));
  }
}

main(int argc, char *argv[]) {
  assert(argc>1);
  int N = atoi(argv[1]);
  assert(N>0);
  
  superpos sup[2];
  
  sup[0].insert(1,1);
  
  cout << "P3" << endl;
  cout << N << " " << N << endl;
  cout << 255 << endl;
  ligne(N, sup[0]);
  
  for (int i=0; i<N-1; i++) {
    sup[(i+1)%2].clear();
    evol(N, sup[i%2], sup[(i+1)%2]);
    ligne(N, sup[(i+1)%2]);
  }
}
  
  
