/*******************************************************************************
+
+  LEDA-R  3.2.1
+
+  _bellman_ford.c modified in bf.cc
+
+  Copyright (c) 1995  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/


/*******************************************************************************
*                                                                              *
*  BELLMAN FORD , modified + becames *, the neutral element 0 becames 1, and   *
*                 min or max can be choosen by parameter                       *
*                                                                              *
*******************************************************************************/

#include <LEDA/graph_alg.h>
#include <LEDA/b_queue.h>
#include "bf.h"

int bf_min(double a, double b) {return a+precision<b;}
int bf_max(double a, double b) {return a-precision>b;}

bool bellman_ford(const graph& G, node s, const edge_array<double>& cost, 
                                          node_array<double>& dist, 
                                          node_array<edge>& pred,
                                          int (*cmp)(double,double),
                                          double init_val ) 

/* single source shortest paths from s using a queue (breadth first search)
   computes for all nodes v:
   a) dist[v] = cost of shortest path from s to v
   b) pred[v] = predecessor edge of v in shortest paths tree
*/

{ 
  node_array<int> count(G,0);

  int n = G.number_of_nodes();

  node_list Q;

  node u,v;
  edge e;

  forall_nodes(v,G) 
  { pred[v] = 0;
    dist[v] = init_val; 
   }

  dist[s] = 1;  // 1 is neutral element for *
  Q.append(s);

  while(! Q.empty() )
  { u = Q.pop();

    if (++count[u] > n) return false;   // negative cycle

    double du = dist[u];

    forall_adj_edges(e,u) 
    { v = target(e);
      double c = du * cost[e]; // costs are now multiplied
      if ((*cmp)(c, dist[v]))
      { dist[v] = c; 
        pred[v] = e;
        if (!Q.member(v)) Q.append(v);
       }
     } 
   }
  return true;
}

bool bf_greater(const graph& G, node s, const edge_array<double>& cost)
{
  node_array<double>& dist(G);
  node_array<edge>&   pred(G);
  return bellman_ford(G,s,cost,dist,pred,bf_max,0);
}

bool bf_less(const graph& G, node s, const edge_array<double>& cost)
{
  node_array<double>& dist(G);
  node_array<edge>&   pred(G);
  return bellman_ford(G,s,cost,dist,pred,bf_min,MAXDOUBLE);
}
